<!DOCTYPE html>
<html lang="en">
<head>
        <meta charset="utf-8" />
        <title><?= APP_TITLE; ?> | Admin Dashboard</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta content="" name="author" />
        <!-- BEGIN GLOBAL MANDATORY STYLES -->
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">
        <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css" rel="stylesheet">
		<link href="https://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&amp;subset=all" rel="stylesheet" type="text/css" />
        <link href="<?=base_url();?>assets/global/plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="<?=base_url();?>assets/global/plugins/simple-line-icons/simple-line-icons.min.css" rel="stylesheet" type="text/css" />
        <!--<link href="<?//=base_url();?>assets/global/plugins/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />-->
        <link href="<?=base_url();?>assets/global/plugins/bootstrap-switch/css/bootstrap-switch.min.css" rel="stylesheet" type="text/css" />
        <!-- END GLOBAL MANDATORY STYLES -->
        <!-- BEGIN PAGE LEVEL PLUGINS -->
        <link href="<?=base_url();?>assets/global/plugins/bootstrap-daterangepicker/daterangepicker.min.css" rel="stylesheet" type="text/css" />
        <link href="<?=base_url();?>assets/global/plugins/morris/morris.css" rel="stylesheet" type="text/css" />
        <link href="<?=base_url();?>assets/global/plugins/fullcalendar/fullcalendar.min.css" rel="stylesheet" type="text/css" />
        <link href="<?=base_url();?>assets/global/plugins/jqvmap/jqvmap/jqvmap.css" rel="stylesheet" type="text/css" />
        <!-- END PAGE LEVEL PLUGINS -->
        <!-- BEGIN THEME GLOBAL STYLES -->
        <link href="<?=base_url();?>assets/global/plugins/bootstrap-toastr/toastr.min.css" rel="stylesheet" type="text/css" />
        <link href="<?=base_url();?>assets/global/css/components.min.css" rel="stylesheet" id="style_components" type="text/css" />
        <link href="<?=base_url();?>assets/global/css/plugins.min.css" rel="stylesheet" type="text/css" />
                <link href="<?=base_url();?>assets/global/plugins/datatables/datatables.min.css" rel="stylesheet" type="text/css" />
        <link href="<?=base_url();?>assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css" rel="stylesheet" type="text/css" />
        <!-- END THEME GLOBAL STYLES -->
        <!-- BEGIN THEME LAYOUT STYLES -->
        <link href="<?=base_url();?>assets/layouts/layout4/css/layout.min.css" rel="stylesheet" type="text/css" />
        <link href="<?=base_url();?>assets/layouts/layout4/css/themes/default.min.css" rel="stylesheet" type="text/css" id="style_color" />
        <link href="<?=base_url();?>assets/layouts/layout4/css/custom.min.css" rel="stylesheet" type="text/css" />
        <link href="<?=base_url();?>assets/global/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css" rel="stylesheet" type="text/css" />
        <!-- END THEME LAYOUT STYLES -->
		<style>
		    .blinking{
    animation:blinkingText 1.2s infinite;
    color:red;
}
@keyframes blinkingText{
    0%{     color: red;    }
    49%{    color: red; }
    60%{    color: transparent; }
    99%{    color:transparent;  }
    100%{   color: red;    }
}


.table-fixed thead {
  width: 97%;
}
.table-fixed tbody {
  height: 230px;
  overflow-y: auto;
  width: 100%;
}
.table-fixed thead, .table-fixed tbody, .table-fixed tr, .table-fixed td, .table-fixed th {
  display: block;
}
.table-fixed tbody td, .table-fixed thead > tr> th {
  float: left;
  border-bottom-width: 0;
}
		    
		</style>
		 </head>
    <!-- END HEAD -->

    <body class="page-container-bg-solid page-header-fixed page-sidebar-closed-hide-logo">
        <!-- BEGIN HEADER -->
        <?php $this->load->view('admin/common/header');?>
        <!-- END HEADER -->
        <!-- BEGIN HEADER & CONTENT DIVIDER -->
        <div class="clearfix"> </div>
        <!-- END HEADER & CONTENT DIVIDER -->
        <!-- BEGIN CONTAINER -->
        <div class="page-container">
            <!-- BEGIN SIDEBAR -->
            <?php $this->load->view('admin/common/aside');?>
            <!-- END SIDEBAR -->
            <!-- BEGIN CONTENT -->
            <div class="page-content-wrapper">
                <!-- BEGIN CONTENT BODY -->
                <div class="page-content">
                    <!-- BEGIN PAGE HEAD-->
                    <div class="page-head">
                        <!-- BEGIN PAGE TITLE -->
                        <div class="page-title">
                            <h1>Admin Dashboard 
                                <!--<small>statistics, charts, recent events and reports</small>-->
                            </h1>
                        </div>
                        <!-- END PAGE TITLE -->
                        <!-- BEGIN PAGE TOOLBAR -->
                        <!--<div class="page-toolbar">
                            <div id="dashboard-report-range" data-display-range="0" class="pull-right tooltips btn btn-fit-height green" data-placement="left" data-original-title="Change dashboard date range">
                                <i class="icon-calendar"></i>&nbsp;
                                <span class="thin uppercase hidden-xs"></span>&nbsp;
                                <i class="fa fa-angle-down"></i>
                            </div>
                        </div>-->
                        <!-- END PAGE TOOLBAR -->
                    </div>
                    <!-- END PAGE HEAD-->
                    <!-- BEGIN PAGE BREADCRUMB -->
                    <ul class="page-breadcrumb breadcrumb">
                        <li>
                           <!-- <a href="index-2.html">Home</a>-->
                         <a href="#">Home</a>

                            <i class="fa fa-circle"></i>
                        </li>
                        <li>
                            <span class="active">Dashboard</span>
                        </li>
                    </ul>
                    <!-- END PAGE BREADCRUMB -->
                    <!-- BEGIN PAGE BASE CONTENT -->
                    <div class="row widget-row">
                             
                                
                                <!-- BEGIN WIDGET THUMB -->
                                
                                  
                                    <div class="col-md-3">
                                    <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                                        <h4 class="widget-thumb-heading"> Total Patients</h4>
                                        <div class="widget-thumb-wrap">
                                            <i class="widget-thumb-icon bg-green icon-users"></i>
                                            <div class="widget-thumb-body">
                                                <span class="widget-thumb-subtitle"></span>
                                                
                                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="<?= number_format($count_guard); ?>"><?= number_format($count_guard); ?></span>
                                            </div>
                                            </div>
                                        </div>
                                        </div>
                                        
                                <div class="col-md-3">
                                    <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                                        <h4 class="widget-thumb-heading"> Active Quarantine Patients</h4>
                                        <div class="widget-thumb-wrap">
                                            <i class="widget-thumb-icon bg-green icon-users"></i>
                                            <div class="widget-thumb-body">
                                                <span class="widget-thumb-subtitle"></span>
                                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="<?= number_format($count_guard_active); ?>"><?= number_format($count_guard_active); ?></span>
                                            </div>
                                            </div>
                                        </div>
                                </div>
                                
                                <div class="col-md-3">
                                    <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                                        <h4 class="widget-thumb-heading"> Complete Quarantine Patients</h4>
                                        <div class="widget-thumb-wrap">
                                            <i class="widget-thumb-icon bg-green icon-users"></i>
                                            <div class="widget-thumb-body">
                                                <span class="widget-thumb-subtitle"></span>
                                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="<?= number_format($count_guard_nonactive); ?>"><?= number_format($count_guard_nonactive); ?></span>
                                            </div>
                                            </div>
                                        </div>
                                </div>
                                

                                 
                                   

                
                    </div>
                    
                    <div class="row widget-row">
                        <div class="col-md-3">
                           
                               <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                                <h4 class="widget-thumb-heading"> Total Quarantine Location</h4>
                                <div class="widget-thumb-wrap">
                                    <i class="widget-thumb-icon bg-green icon-users"></i>
                                    <div class="widget-thumb-body">
                                        <span class="widget-thumb-subtitle"></span>
                                        
                                        <span class="widget-thumb-body-stat" data-counter="counterup" data-value="<?= number_format($quorantine_location); ?>"><?= number_format($quorantine_location); ?></span>
                                    </div>
                                  
                                </div>
                            </div>
                          </div>
                        
                        <div class="col-md-3">
                           
                               <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                                <h4 class="widget-thumb-heading"> Employee Registration</h4>
                                <div class="widget-thumb-wrap">
                                    <i class="widget-thumb-icon bg-green icon-users"></i>
                                    <div class="widget-thumb-body">
                                        <span class="widget-thumb-subtitle"></span>
                                        
                                        <span class="widget-thumb-body-stat" data-counter="counterup" data-value="<?= number_format($employee_count); ?>"><?= number_format($employee_count); ?></span>
                                    </div>
                                  
                                </div>
                            </div>
                          </div>
                          
                                <div class="col-md-3">
                                    <div class="widget-thumb widget-bg-color-white text-uppercase margin-bottom-20 bordered">
                                        <h4 class="widget-thumb-heading"> Announcement</h4>
                                        <div class="widget-thumb-wrap">
                                            <i class="widget-thumb-icon bg-green icon-users"></i>
                                            <div class="widget-thumb-body">
                                                <span class="widget-thumb-subtitle"></span>
                                                <span class="widget-thumb-body-stat" data-counter="counterup" data-value="<?= number_format($announcement_count); ?>"><?= number_format($announcement_count); ?></span>
                                            </div>
                                            </div>
                                        </div>
                                </div>
                    </div>

                    
                    <div class="row">
                        <div class="col-md-12">
                        <div class="portlet light portlet-fit portlet-datatable bordered ">
                            <div class="portlet-title">
                                
                                <h3>Quarantine User Out Circle Status</h3>
                            </div>
                        
                         <div class="portlet-body" style="height:auto;">
                                    <div class="table-container">
                                        <table class="table table-striped table-bordered  table-hover" id="dtBasicExample">
                                            <thead>
                                                <tr>
                                                    <th>Patient Name </th>
                                                    <th>Contact No </th>
                                                    <th>Quarantine Address</th>
                                                    <th>City</th>
                                                    <th>Time</th>
                                                    <th>Status</th>
                                                    <th>Informed Count</th>
                                                    <th>Action</th>
                                                   
                                                </tr>
                                            </thead>
                                            <tbody>
												
                                                <?php $i=1;
                                                if(!empty($location_arr)) { 
												foreach($location_arr as $guardid => $row) {  
												 if($row['status'] == 'Out Circle' &&  empty($row['inform_status']) ) {
												?>
                                                <tr>  
													<td><?=$row['guard']; ?></td>
													<td><?=$row['guard_contact']; ?></td>
													<td><?=$row['office_name']; ?></td>
													<td><?=$row['office_city']; ?></td>
													<td><?= !empty($row['location']->datetime) ? date('Y-m-d H:i:s', strtotime($row['location']->datetime)) : ''; ?></td>
													
													<td><span class="blinking"><?= !empty($row['status']) ? $row['status'] : ''; ?></span></td>
													<td><?php  echo $row['inform_count']; ?></td>
												    <td><button type="button" class="btn btn-sm btn-primary history_btn"  data-patientid="<?= $guardid; ?>">History</button>
												    <a class="btn btn-success btn-sm" href="<?= base_url(); ?>Admin/map_view/<?= $row['location']->l_id; ?>">Map</a>
												    
												    <form action="<?= base_url(); ?>Admin/inform_outcircle" method="POST" >
												        <input type="hidden" name="location_id" value="<?=$row['location']->l_id; ?>" />
												        <button type="submit" class="btn btn-sm btn-info ">Inform</button>
											        </form>
												    </td>	
                                                </tr>
                                                
                                                
                                                <?php } 
                                                
                                                } } ?>
											</tbody>
                                            </table>
                        
                    </div>
                    
               
                </div>
                
                    </div>
                    </div>
                <!-- END CONTENT BODY -->
                
                        <!-- /.modal -->
                        <div class="modal fade bs-modal-lg" id="large" tabindex="-1" role="dialog" aria-hidden="true">
                            <div class="modal-dialog modal-lg">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                                        <h4 class="modal-title">Patient History of <span id="patient_name"></span></h4>
                                    </div>
                                    <div class="modal-body table-wrapper-scroll-y my-custom-scrollbar">
                                        <div class="col-md-6">
                                            <label class="control-label">Date</label>
                                            <input type="text" class="form-control date-picker" data-date-format="yyyy-mm-dd" name="history_dt" id="history_dt" value="" placeholder="Select Date" />
                                            <input type="hidden" id="history_gid" value="" />
                                        </div>
                                        
                                        <div class="clearfix"></div>
                                        <br><br>
                                        <div class="table_body">
                                        
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn dark btn-outline" data-dismiss="modal">Close</button>
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <!-- /.modal -->  
                
            </div>
            <!-- END CONTENT -->
        </div>
        <!-- END CONTAINER -->
        <!-- BEGIN FOOTER -->
        <?php $this->load->view('admin/common/footer');?>
        <!-- END FOOTER -->
        <!-- BEGIN QUICK NAV -->
        <!-- END QUICK NAV -->
        <!-- BEGIN CORE PLUGINS -->
        <script src="<?=base_url();?>assets/global/plugins/jquery.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/js.cookie.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jquery.blockui.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/bootstrap-switch/js/bootstrap-switch.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/bootstrap-toastr/toastr.min.js" type="text/javascript"></script>  
        
                 <script src="<?=base_url();?>assets/global/scripts/datatable.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/datatables/datatables.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js" type="text/javascript"></script>
        <!-- END CORE PLUGINS -->
        <!-- BEGIN PAGE LEVEL PLUGINS -->
        <script src="<?=base_url();?>assets/global/plugins/moment.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/bootstrap-daterangepicker/daterangepicker.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/morris/morris.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/morris/raphael-min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/counterup/jquery.waypoints.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/counterup/jquery.counterup.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/amcharts/amcharts.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/amcharts/serial.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/amcharts/pie.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/amcharts/radar.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/amcharts/themes/light.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/amcharts/themes/patterns.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/amcharts/themes/chalk.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/ammap/ammap.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/ammap/maps/js/worldLow.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/amcharts/amstockcharts/amstock.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/fullcalendar/fullcalendar.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/horizontal-timeline/horizontal-timeline.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/flot/jquery.flot.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/flot/jquery.flot.resize.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/flot/jquery.flot.categories.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jquery-easypiechart/jquery.easypiechart.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jquery.sparkline.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jqvmap/jqvmap/jquery.vmap.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.russia.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.world.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.europe.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.germany.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jqvmap/jqvmap/maps/jquery.vmap.usa.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/global/plugins/jqvmap/jqvmap/data/jquery.vmap.sampledata.js" type="text/javascript"></script>
        
        <script src="<?=base_url();?>assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
        <!-- END PAGE LEVEL PLUGINS -->
        <!-- BEGIN THEME GLOBAL SCRIPTS -->
        <script src="<?=base_url();?>assets/global/scripts/app.min.js" type="text/javascript"></script>
        <!-- END THEME GLOBAL SCRIPTS -->
        <!-- BEGIN PAGE LEVEL SCRIPTS -->
        <script src="<?=base_url();?>assets/pages/scripts/dashboard.min.js" type="text/javascript"></script>
        <!-- END PAGE LEVEL SCRIPTS -->
        <!-- BEGIN THEME LAYOUT SCRIPTS -->
        <script src="<?=base_url();?>assets/pages/scripts/ui-toastr.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/layouts/layout4/scripts/layout.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/layouts/layout4/scripts/demo.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/layouts/global/scripts/quick-sidebar.min.js" type="text/javascript"></script>
        <script src="<?=base_url();?>assets/layouts/global/scripts/quick-nav.min.js" type="text/javascript"></script>
        <!-- END THEME LAYOUT SCRIPTS -->
        
        <script>
            $(function() {
                $("input[type='text'].date-picker").datepicker({
                    autoclose: true
                });
                
                $("#history_dt").change(function() {
                    
			        var tbl = '';
                    var guardid = $("input[type='hidden']#history_gid").val();
                    var gdate = $("input[type='text']#history_dt").val();

                    $.ajax({
                        type: 'POST',
                        url: "<?= base_url(); ?>Admin/patient_history",
                        data: {guardid: guardid, gdate: gdate},
                        async: false,
                        success: function(resp) {
                            
                            var res = JSON.parse(resp);
                            
                            console.log(res);
                            tbl += '<table class="table table-stripped table-fixed" ><thead><tr><th class="col-xs-4">Sr. no</th><th class="col-xs-4">Time</th><th class="col-xs-4">Status</th></tr></thead><tbody>';
                            
                            var i = 1;
                            for (var key in res) {
                                var obj = res[key];
                                tbl += '<tr><td class="col-xs-4">'+ i +'</td><td class="col-xs-4">'+obj.date+'</td><td class="col-xs-4">'+ obj.status +'</td></tr>';
                                $("input[type='hidden']#history_gid").val(obj.guardid);
                                $("span#patient_name").html('<b>"' +  obj.guard + '"<b>');
                               i++;
                            }
                            tbl += '</tbody></table>';
                            
                        }
                    });
                    
                    $("#large .modal-body .table_body").html(tbl);
                    
                    
                });
                
               $("#dtBasicExample").DataTable({
                  "ordering": false
                }); 
                
                $("#dtBasicExample").on("click", ".history_btn", function() {
			        var tbl = '';
                    var guardid = $(this).attr('data-patientid');

                    $.ajax({
                        type: 'POST',
                        url: "<?= base_url(); ?>Admin/patient_history",
                        data: {guardid: guardid},
                        async: false,
                        success: function(resp) {
                            
                            var res = JSON.parse(resp);
                            
                            console.log(res);
                            tbl += '<table class="table table-stripped   table-fixed" ><thead><tr><th class="col-xs-4">Sr. no</th><th class="col-xs-4">Time</th><th class="col-xs-4">Status</th></tr></thead><tbody>';
                            
                            var i = 1;
                            for (var key in res) {
                                var obj = res[key];
                                tbl += '<tr><td class="col-xs-4">'+ i +'</td><td class="col-xs-4">'+obj.date+'</td><td class="col-xs-4">'+ obj.status +'</td></tr>';
                                $("input[type='hidden']#history_gid").val(obj.guardid);
                                $("input[type='text']#history_dt").val(obj.date_formated);
                                $("span#patient_name").html('<b>"' +  obj.guard + '"<b>');
                               i++;
                            }
                            tbl += '</tbody></table>';
                            
                        }
                    });
                    
                $("#large .modal-body .table_body").html(tbl);
                $("div#large").modal();
                    
            });
            
                     <?php 
            
            if($this->session->flashdata('info_success') == 1 ) { ?>
                    toastr.success('Successfully Informed', 'Patient');
            <?php } ?>
               
        });
        
            
        </script>
</body>
</html>