<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class PositiveReport extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model("Positive_model");
        
        $this->load->library("Custom");
        $this->load->helper(array('form', 'url'));

        date_default_timezone_set('Asia/Kolkata');
        if (empty($this->session->userdata("name"))) {
            redirect("Login");
        }
    }
    
    public function index() {
        

        $survey_st_arr = array();
        $survey_st = $this->db->where('Deleted_DT IS NULL')->get('tbl_containment')->result();
        if(!empty($survey_st)) {
            foreach($survey_st as $srvy) {
                $survey_st_arr[$srvy->patient_name] = $srvy->Inserted_DT; 
            }
        }
        
        $high_risk_arr = array();
        $highrisk = $this->db->select('count(add_id) as pcount, patient_id')->where('deleted_DT IS NULL')->where('risk_type', 1)
                            ->group_by('patient_id')->get('tbl_risk_addmore')->result();
        if(!empty($highrisk)) {
            foreach($highrisk as $hrisk) {
                $high_risk_arr[$hrisk->patient_id] = $hrisk->pcount; 
            }
        }
        
// $hour = abs($timestamp2 - $timestamp1)/(60*60)
        
        $low_risk_arr = array();
        $lowrisk = $this->db->select('count(add_id) as pcount, patient_id')->where('deleted_DT IS NULL')->where('risk_type', 2)
                            ->group_by('patient_id')->get('tbl_risk_addmore')->result();
        if(!empty($lowrisk)) {
            foreach($lowrisk as $lrisk) {
                $low_risk_arr[$lrisk->patient_id] = $hrisk->pcount; 
            }
        }
        
        
        $red_spots = array();
        $redspts = $this->db->where('Deleted_Dt IS NULL')->get('tbl_red_spot')->result();
        if(!empty($redspts)) {
            foreach($redspts as $rspt) {
                $red_spots[$rspt->Patient_Id] = $rspt->Inserted_Dt; 
            }
        }
        
        
        $area_seal_arr = array();
        $areaseals = $this->db->where('Deleted_DT IS NULL')->get('tbl_area_sealed')->result();
        if(!empty($areaseals)) {
            foreach($areaseals as $areasl) {
                $area_seal_arr[$areasl->patient_id] = $areasl->Inserted_DT; 
            }
        }
        
        
        $patients = $this->Positive_model->fetch_positive_patients();
//print_R($patients);exit;
        $data['patients'] = array();
        if(!empty($patients)) {
            foreach($patients as $guard) {
                $data['patients'][$guard->id]['id'] = $guard->id; 
                $data['patients'][$guard->id]['name'] = $guard->name; 
                $data['patients'][$guard->id]['health_center'] = $guard->Health_center; 
                $data['patients'][$guard->id]['red_spot'] = !empty($red_spots[$guard->id]) ?  date('Y-m-d H:i:s', strtotime($red_spots[$guard->id])) : 'Alert'; 
                $data['patients'][$guard->id]['area_sealed'] = !empty($area_seal_arr[$guard->id]) ?  date('Y-m-d H:i:s', strtotime($area_seal_arr[$guard->id])) : 'Alert';
                $data['patients'][$guard->id]['survey_time'] = !empty($survey_st_arr[$guard->id]) ?  date('Y-m-d H:i:s', strtotime($survey_st_arr[$guard->id])) : 'Alert';
                $data['patients'][$guard->id]['high_risk_count'] = !empty($high_risk_arr[$guard->id]) ? $high_risk_arr[$guard->id] : 0;
                $data['patients'][$guard->id]['low_risk_count'] = !empty($low_risk_arr[$guard->id]) ?  $low_risk_arr[$guard->id] : 0;
                
                
                $data['patients'][$guard->id]['redspot_alert_flag'] = $this->calculate_alert($guard->inserted_DT, $data['patients'][$guard->id]['red_spot']);
                $data['patients'][$guard->id]['area_sealed_alert_flag'] = $this->calculate_alert($guard->inserted_DT, $data['patients'][$guard->id]['area_sealed']);
                $data['patients'][$guard->id]['survey_alert_flag'] = $this->calculate_alert($guard->inserted_DT, $data['patients'][$guard->id]['survey_time']);
                   
            }
        }
        
        
        $data['offices'] = array();
        $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
        if(!empty($offices)) {
            foreach($offices as $office) {
                $data['offices'][$office->id] = $office; 
            }
        }
        

        

        

        $this->load->view('admin/report/positive_grid', $data);
    }
    
    public function calculate_alert($patient_insert, $inserted) {
        $alert_flag = true;
        if(!empty($patient_insert) && !empty($inserted)) {
            $timestamp1 = strtotime($patient_insert);
            $timestamp2 = strtotime($inserted);
            
            $diff1 = abs($timestamp2 - $timestamp1)/(60*60);
            if($diff1 > 24) {
                $alert_flag = false;
            }
        } else {
            $alert_flag = false;
        }
        
        return $alert_flag;
    }



}