<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Labtest extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model("Labtest_Model");
        
        $this->load->library("Custom");
        $this->load->helper(array('form', 'url'));

        date_default_timezone_set('Asia/Kolkata');
        if (empty($this->session->userdata("name"))) {
            redirect("Login");
        }
    }
    
    public function index() {
        $patients = $this->Labtest_Model->fetch_patients();
//print_R($patients);exit;
        $data['patients'] = array();
        if(!empty($patients)) {
            foreach($patients as $guard) {
                $data['patients'][$guard->id]['id'] = $guard->id; 
                    $data['patients'][$guard->id]['name'] = $guard->name; 
                $data['patients'][$guard->id]['contact'] = $guard->contact; 
            }
        }
        
        $labs = $this->Labtest_Model->fetch_labs();
        $data['labs'] = array();
        if(!empty($labs)) {
            foreach($labs as $lab) {
                $data['labs'][$lab->lab_id]['id'] = $lab->lab_id; 
                $data['labs'][$lab->lab_id]['name'] = $lab->lab_name; 
            }
        }
        $data['result'] = $this->Labtest_Model->fetch_data();

        $this->load->view('admin/lab_test_grid', $data);
    }
    
    public function add_lab_test() {
       // $data['labs'] = $this->Labtest_Model->fetch_labs();
        $patients = $this->Labtest_Model->fetch_patients();
//print_R($patients);exit;
        $data['patients'] = array();
        if(!empty($patients)) {
            foreach($patients as $guard) {
                $data['patients'][$guard->id]['id'] = $guard->id; 
                    $data['patients'][$guard->id]['name'] = $guard->name; 
                $data['patients'][$guard->id]['contact'] = $guard->contact; 
            }
        }
        $this->load->view('admin/add_lab_test', $data);
    }
    
    public function test_insert() {
//echo '<pre>';
//print_R($_POST);exit;
        $this->load->library('form_validation');
//Array
//(
//    [patientid] => 12
//    [contactno] => 1234567890
//    [sample_flag] => 1
//    [collected_date] => 2020-04-01
    //    [lab_type] => 2
//    [lab_id] => 1
//)
        $this->form_validation->set_rules('patientid', 'Patient Name', 'required');
        $this->form_validation->set_rules('contactno', 'Patient Contact No.', 'required');
        //$this->form_validation->set_rules('sample_flag', 'Sample Collected', 'required');
        $this->form_validation->set_rules('collected_date', 'Date of Collection', 'required');
        $this->form_validation->set_rules('lab_type', 'Lab Type', 'required');
        $this->form_validation->set_rules('lab_id', 'Lab Name', 'required');
        
        if ($this->form_validation->run() == FALSE) {
            $data['labs'] = $this->Labtest_Model->fetch_labs();
            $patients = $this->Labtest_Model->fetch_patients();
    //print_R($patients);exit;
            $data['patients'] = array();
            if(!empty($patients)) {
                foreach($patients as $guard) {
                    $data['patients'][$guard->id]['id'] = $guard->id; 
                        $data['patients'][$guard->id]['name'] = $guard->name; 
                    $data['patients'][$guard->id]['contact'] = $guard->contact; 
                }
            }
            $this->load->view('admin/add_lab_test', $data);
        } else {
            $this->Labtest_Model->insertlab();
            $this->session->set_flashdata(array("success" => 1));
            redirect('Labtest');
        }
        
        
        
        
    }
    
    
    public function getgovernmentlab()
	{
	    $showdrop = $this->db->where('lab_type',1)->where('Deleted_DT',NULL)->order_by('lab_id','desc')->get('mst_labs')->result();
	    $data='';
	    
	    if(count($showdrop)>0)
	    {
    	    $data.='<option value="">Select Lab</option>';
    	    foreach($showdrop as $row)
    	    {
    	        $data.='<option value="'.$row->lab_id.'">'.$row->lab_name.'</option>';
    	    }
	    }
	    else
	    {
	        $data.='<option value="">Select Lab</option>';
	    }
	    echo $data;
	}
	
	public function getprivatelab()
	{
	    $showdrop = $this->db->where('lab_type',2)->where('Deleted_DT',NULL)->order_by('lab_id','desc')->get('mst_labs')->result();
	    $data='';
	    
	    if(count($showdrop)>0)
	    {
    	    $data.='<option value="">Select Lab</option>';
    	    foreach($showdrop as $row)
    	    {
    	        $data.='<option value="'.$row->lab_id.'">'.$row->lab_name.'</option>';
    	    }
	    }
	    else
	    {
	        $data.='<option value="">Select Lab</option>';
	    }
	    echo $data;
	}

}