<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class HighriskReport extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model("Positive_model");
        
        $this->load->library("Custom");
        $this->load->helper(array('form', 'url'));

        date_default_timezone_set('Asia/Kolkata');
        if (empty($this->session->userdata("name"))) {
            redirect("Login");
        }
    }
    
    public function index() {
        
        $survey_st_arr = array();
        $survey_st = $this->db->where('Deleted_DT IS NULL')->get('tbl_containment')->result();
        if(!empty($survey_st)) {
            foreach($survey_st as $srvy) {
                $survey_st_arr[$srvy->patient_name] = $srvy->Inserted_DT; 
            }
        }
        
        $high_risk_arr = array();
        $highrisk = $this->db->select('count(add_id) as pcount, patient_id')->where('deleted_DT IS NULL')->where('risk_type', 1)
                            ->group_by('patient_id')->get('tbl_risk_addmore')->result();
        if(!empty($highrisk)) {
            foreach($highrisk as $hrisk) {
                $high_risk_arr[$hrisk->patient_id] = $hrisk->pcount; 
            }
        }
        
        $low_risk_arr = array();
        $lowrisk = $this->db->select('count(add_id) as pcount, patient_id')->where('deleted_DT IS NULL')->where('risk_type', 2)
                            ->group_by('patient_id')->get('tbl_risk_addmore')->result();
        if(!empty($lowrisk)) {
            foreach($lowrisk as $lrisk) {
                $low_risk_arr[$lrisk->patient_id] = $hrisk->pcount; 
            }
        }
        
        
        $red_spots = array();
        $redspts = $this->db->where('Deleted_Dt IS NULL')->get('tbl_red_spot')->result();
        if(!empty($redspts)) {
            foreach($redspts as $rspt) {
                $red_spots[$rspt->Patient_Id] = $rspt->Inserted_Dt; 
            }
        }

        //quarantine
        $quaran_arr = array();
	    $quarantines = $this->db->where('Deleted_DT',NULL)->order_by('id','desc')->get('mst_office')->result();
	    if(!empty($quarantines)) {
    	    foreach($quarantines as $quarntne) {
    	        $quaran_arr[$quarntne->id] = $quarntne->name;
    	    }
	    }
	    
	    //isolation
        $isolation_arr = array();
	    $isolations = $this->db->where('type', 2)->where('Deleted_DT',NULL)->order_by('hos_id','desc')->get('mst_hospital')->result();
	    if(!empty($isolations)) {
    	    foreach($isolations as $isolation) {
    	        $isolation_arr[$isolation->hos_id] = $isolation->hos_name;
    	    }
	    }
	    
	    //hospital
        $hosp_arr = array();
	    $hospitals = $this->db->where('type',1)->where('Deleted_DT',NULL)->order_by('hos_id','desc')->get('mst_hospital')->result();
	    if(!empty($hospitals)) {
    	    foreach($hospitals as $hospital) {
    	        $hosp_arr[$hospital->hos_id] = $hospital->hos_name;
    	    }
	    }
	    
	    //swab and result
        $swab_arr = array();
	    $swabs = $this->db->where('Deleted_DT',NULL)->get('lab_tests')->result();
	    if(!empty($swabs)) {
    	    foreach($swabs as $swab) {
    	        $swab_arr[$swab->Patient_Id] = $swab->Sample_Collection_Flag;
    	    }
	    }

        
        
        $patients = $this->Positive_model->fetch_positive_patients();
//print_R($patients);exit;
        $data['patients'] = array();
        if(!empty($patients)) {
            foreach($patients as $guard) {
                $data['patients'][$guard->id]['id'] = $guard->id; 
                $data['patients'][$guard->id]['name'] = $guard->name; 
                $data['patients'][$guard->id]['health_center'] = $guard->Health_center; 
                
                if(!empty($guard->advisal) && !empty($guard->advise_location)) {
                    if($guard->advisal == 1 && !empty($quaran_arr[$guard->advise_location])) { //home quarantine
                        $data['patients'][$guard->id]['shift_to'] = $quaran_arr[$guard->advise_location];
                    } elseif($guard->advisal == 2 && !empty($isolation_arr[$guard->advise_location])) { //isolation
                        $data['patients'][$guard->id]['shift_to'] = $isolation_arr[$guard->advise_location];
                    } elseif($guard->advisal == 3 && !empty($hosp_arr[$guard->advise_location])) { //government hospital
                        $data['patients'][$guard->id]['shift_to'] = $hosp_arr[$guard->advise_location];
                    } else {
                        $data['patients'][$guard->id]['shift_to'] = '';
                    }
                 } else {
                      $data['patients'][$guard->id]['shift_to'] = '';
                 }
                 
                 
                
                $data['patients'][$guard->id]['swab'] = !empty($swab_arr[$guard->id]) ?  $swab_arr[$guard->id] : ''; 
                $data['patients'][$guard->id]['swab_result'] = ''; 
                
                $data['patients'][$guard->id]['high_risk_count'] = !empty($high_risk_arr[$guard->id]) ? $high_risk_arr[$guard->id] : 0;
                
                
            }
        }
        
        
        $data['offices'] = array();
        $offices = $this->db->where('Deleted_DT IS NULL')->get('mst_office')->result();
        if(!empty($offices)) {
            foreach($offices as $office) {
                $data['offices'][$office->id] = $office; 
            }
        }
        
        $this->load->view('admin/report/high_risk_grid', $data);
    }
    
    public function add_lab_test() {
       // $data['labs'] = $this->Labtest_Model->fetch_labs();
        $patients = $this->Labtest_Model->fetch_patients();
//print_R($patients);exit;
        $data['patients'] = array();
        if(!empty($patients)) {
            foreach($patients as $guard) {
                $data['patients'][$guard->id]['id'] = $guard->id; 
                    $data['patients'][$guard->id]['name'] = $guard->name; 
                $data['patients'][$guard->id]['contact'] = $guard->contact; 
            }
        }
        $this->load->view('admin/add_lab_test', $data);
    }
    
    public function test_insert() {
//echo '<pre>';
//print_R($_POST);exit;
        $this->load->library('form_validation');
//Array
//(
//    [patientid] => 12
//    [contactno] => 1234567890
//    [sample_flag] => 1
//    [collected_date] => 2020-04-01
    //    [lab_type] => 2
//    [lab_id] => 1
//)
        $this->form_validation->set_rules('patientid', 'Patient Name', 'required');
        $this->form_validation->set_rules('contactno', 'Patient Contact No.', 'required');
        //$this->form_validation->set_rules('sample_flag', 'Sample Collected', 'required');
        $this->form_validation->set_rules('collected_date', 'Date of Collection', 'required');
        $this->form_validation->set_rules('lab_type', 'Lab Type', 'required');
        $this->form_validation->set_rules('lab_id', 'Lab Name', 'required');
        
        if ($this->form_validation->run() == FALSE) {
            $data['labs'] = $this->Labtest_Model->fetch_labs();
            $patients = $this->Labtest_Model->fetch_patients();
    //print_R($patients);exit;
            $data['patients'] = array();
            if(!empty($patients)) {
                foreach($patients as $guard) {
                    $data['patients'][$guard->id]['id'] = $guard->id; 
                        $data['patients'][$guard->id]['name'] = $guard->name; 
                    $data['patients'][$guard->id]['contact'] = $guard->contact; 
                }
            }
            $this->load->view('admin/add_lab_test', $data);
        } else {
            $this->Labtest_Model->insertlab();
            $this->session->set_flashdata(array("success" => 1));
            redirect('Labtest');
        }
        
        
        
        
    }
    
    
    public function getgovernmentlab()
	{
	    $showdrop = $this->db->where('lab_type',1)->where('Deleted_DT',NULL)->order_by('lab_id','desc')->get('mst_labs')->result();
	    $data='';
	    
	    if(count($showdrop)>0)
	    {
    	    $data.='<option value="">Select Lab</option>';
    	    foreach($showdrop as $row)
    	    {
    	        $data.='<option value="'.$row->lab_id.'">'.$row->lab_name.'</option>';
    	    }
	    }
	    else
	    {
	        $data.='<option value="">Select Lab</option>';
	    }
	    echo $data;
	}
	
	public function getprivatelab()
	{
	    $showdrop = $this->db->where('lab_type',2)->where('Deleted_DT',NULL)->order_by('lab_id','desc')->get('mst_labs')->result();
	    $data='';
	    
	    if(count($showdrop)>0)
	    {
    	    $data.='<option value="">Select Lab</option>';
    	    foreach($showdrop as $row)
    	    {
    	        $data.='<option value="'.$row->lab_id.'">'.$row->lab_name.'</option>';
    	    }
	    }
	    else
	    {
	        $data.='<option value="">Select Lab</option>';
	    }
	    echo $data;
	}

}